# Review Living in the endosymbiotic world of Wolbachia: A centennial review

Rupinder Kaur, $^ { 1 , 2 , \star }$ J. Dylan Shropshire,1,2 Karissa L. Cross,1,2 Brittany Leigh,1,2 Alexander J. Mansueto,1,2   
Victoria Stewart,1,2 Sarah R. Bordenstein,1,2 and Seth R. Bordenstein1,2,3,4, \*   
1Department of Biological Sciences, Vanderbilt University, Nashville, TN 37235, USA   
2Vanderbilt Microbiome Initiative, Vanderbilt University, Nashville, TN 37235, USA   
3Department of Pathology, Microbiology, and Immunology, Vanderbilt University, Nashville, TN 37235, USA   
4Vanderbilt Institute for Infection, Immunology and Inflammation, Vanderbilt University Medical Center, Nashville, TN 37235, USA   
\*Correspondence: rupinder.kaur@vanderbilt.edu (R.K.), s.bordenstein@vanderbilt.edu (S.R.B.)   
https://doi.org/10.1016/j.chom.2021.03.006

# SUMMARY

The most widespread intracellular bacteria in the animal kingdom are maternally inherited endosymbionts of the genus Wolbachia. Their prevalence in arthropods and nematodes worldwide and stunning arsenal of parasitic and mutualistic adaptations make these bacteria a biological archetype for basic studies of symbiosis and applied outcomes for curbing human and agricultural diseases. Here, we conduct a summative, centennial analysis of living in the Wolbachia world. We synthesize literature on Wolbachia’s host range, phylogenetic diversity, genomics, cell biology, and applications to filarial, arboviral, and agricultural diseases. We also review the mobilome of Wolbachia including phage WO and its essentiality to hallmark reproductive phenotypes in arthropods. Finally, the Wolbachia system is an exemplar for discovery-based science education using biodiversity, biotechnology, and bioinformatics lessons. As we approach a century of Wolbachia research, the interdisciplinary science of this symbiosis stands as a model for consolidating and teaching the integrative rules of endosymbiotic life.

# INTRODUCTION

The central roles of microbial symbiosis in the origin of the eukaryotic cell, species formation, ecological interactions, and animal and plant activities across the biosphere are increasingly clear (Bordenstein and Theis, 2015; McFall-Ngai, 2008). The most prevalent symbiotic microbe in the animal world, wherein rules of interspecies engagement and imperatives for research may form, is the Alphaproteobacterium Wolbachia pipientis, first described nearly a century ago as a Rickettsia-like organism in the gonads of various insects including Culex pipiens mosquitoes (Hertig and Wolbach, 1924). These gram-negative, maternally transmitted bacterial endosymbionts belong to the Anaplasmataceae family within the order Rickettsiales (Figure 1A). Since W. pipientis is currently the only member of its genus, it is conventionally referred to as Wolbachia.

In the 1990s, entomologists and microbiologists revealed at least $1 6 \%$ of arthropod species harbor Wolbachia (O’Neill et al., 1992; Werren et al., 1995). As costs for molecular biology techniques plummeted, a stunning variety of hosts were identified, including insects, spiders, mites, and terrestrial isopods, as well as filarial and plant nematodes. Current estimates suggest $\sim 5 0 \%$ of arthropod and several filarial nematode species harbor Wolbachia (Lefoulon et al., 2016; Weinert et al., 2015).

A century in the making, the knowledge in this review serves as a summative gateway to six major topics underpinning the biology of one of the greatest endosymbioses: (1) genome evolution and diversity, (2) mobile elements including temperate phage as a hotspot for genetic novelty and key functions, transposons, and a putative plasmid, (3) cell biology spanning tissue tropism and transmission routes, (4) hallmark phenotypes, genes, and mechanisms crossing the continuum of symbiotic functions, (5) fundamental impacts on host counter-adaptations, extinction, and speciation, and (6) translational applications for positive outcomes on human health and agriculture. We also highlight the worldwide impact of Wolbachia research on science outreach via Discover the Microbes Within! The Wolbachia Project (Lemon et al., 2020). Finally, we note future research directions to improve our understanding of living in the Wolbachia world.

# WOLBACHIA DIVERSITY, EVOLUTIONARY HISTORY, AND GENOMICS

# Diversity

Wolbachia genetic diversity was initially characterized using sequences for the 16S rRNA gene (O’Neill et al., 1992) and the more variable surface protein gene wsp (Zhou et al., 1998). Due to the slow evolutionary rate of 16S rRNA and extensive wsp recombination that posed challenges to resolving Wolbachia strains and phylogenies, a multilocus sequence typing (MLST) system comprising conserved housekeeping genes was established as a standard for Wolbachia classification (Baldo et al., 2006). Wolbachia are subdivided into at least 17 possible phylogenetic supergroups (named A–F, H–Q, and S, detailed in Figure 1B). Notably, the vast majority of Wolbachia genome sequences are from strains of the A and B supergroups, and some supergroups are represented by a single strain only (Table S1). Overall, our understanding of Wolbachia’s genetic diversity is still developing. Recent advances in target enrichment protocols (Hotopp et al., 2017; Kent and Bordenstein, 2010) and whole-genome typing methods with an improved set of MLST loci (Bleidorn and Gerth, 2018) can be used across diverse arthropod species and environments to discover and delineate Wolbachia genomic diversity and phylogenetic classification.

![](images/bfd330a6bb3e64dce340f4aad87573eac93ca6a10ddcc5027f4f08bd1e9b0436.jpg)  
Figure 1. Phylogeny and evolution of Wolbachia   
(A and B) Schematic representation of (A) phylogenetic relationships of Wolbachia and members of the family Anaplasmataceae, with Rickettsia shown as an outgroup, and (B) an unrooted 16S rRNA-based consensus phylogenetic tree of the major and well-established Wolbachia supergroups. The phylogenetic positions of the supergroups are currently tentative based on previously published single gene and multigene analyses. Colors correspond to different patterns of host-Wolbachia associations across the supergroups. Supergroup E is multicolor labeled since the evidence for Wolbachia-associated phenotypes in the host are suggestive but inconclusive. A phage symbol represents Wolbachia supergroups with genomic evidence of intact or relic prophage WO presence. Specific examples of phage association and reproductive phenotypes are listed in Table S2.

# Evolutionary history

Sister genera to Wolbachia include Ehrlichia, Anaplasma, and Rickettsia endosymbionts. The utility of the Wolbachia model to assess directional shifts in the evolution of endosymbiont genome sizes (reduction versus expansion), host ranges (arthropods versus nematodes), and phenotypes (mutualism versus parasitism) has not gone unnoticed. While various studies have attempted to phylogenetically determine these evolutionary transitions by rooting the Wolbachia tree with the closest sister genera, severe systematic errors associated with the extensive divergence between Wolbachia and its closest relatives cause long-branch attraction artifacts that lead to either gross overestimates of the root or ambiguous results for the rooted phylogenetic tree (Bordenstein et al., 2009). Defining a confidently rooted Wolbachia tree is paramount for answering questions such as what is Wolbachia’s original host? What is the direction of ecological and evolutionary changes in host ranges, genome sizes and mobile element acquisitions? Does genome evolution increase or decrease in size over time? Rooting the Wolbachia tree remains one of the major goals for the field and will require more suitable and closely related outgroups.

Moreover, dating the major divergence events between Wolbachia supergroups is an emerging area of research. By extrapolating observed substitutions in the ftsZ gene (a rapidly evolving, cell-cycle gene), the last common ancestor of arthropod supergroups A and B was estimated to be 58–67 million years ago (Ma) (Werren et al., 1995). With a similar approach, supergroups A and B were estimated to diverge from nematode supergroups C and D $\mathord { \sim } 1 0 0$ Ma (Bandi et al., 1998). Genome-scaled Wolbachia datasets were calibrated using putative codivergence times with hosts from the bee genus Nomada, which, which provided an extended time frame of $\sim 2 0 0$ Ma for the divergence event splitting supergroups A and B (Gerth and Bleidorn, 2016). Notably, this older dating suggests an evolutionary alignment of the origin of Wolbachia in arthropods with the diversification of many insect lineages in which Wolbachia occur. Investigation of Wolbachia’s evolutionary history remains a central research focus, and genomic data from more host taxa as well as alternative calibration priors may help pinpoint the evolutionary history and timing.

# Genomics

The first sequenced Wolbachia genome, wMel strain in Drosophila melanogaster from supergroup A, revealed a small 1.3 megabase (Mb) genome littered with mobile genetic elements (Wu et al., 2004). The genome sequences from wBm of Brugia malayi (Foster et al., 2005), wPip of C. pipiens (Klasson et al., 2008), wRi of D. simulans (Klasson et al., 2009), and wAlbB of Aedes albopictus (Mavingui et al., 2012) followed thereafter. Twenty-six complete Wolbachia genomes are available to date

![](images/6051f6c74165f634856ca9947953694871a4ff100a80a19a0ce8297e29d4d4a5.jpg)  
Figure 2. The tripartite symbiosis of bacteriophage WO, Wolbachia, and arthropods   
A) Schematic representation of two phage WO life cycles—lytic and lysogenic—in Wolbachia cells (blue and orange) living in endosymbiosis within an arthropod host cell. During the lytic cycle, phage WO particles are produced and can exit and enter Wolbachia cells to establish new infections, while in the lysogenic cycle, prophage WO is stably integrated into the Wolbachia chromosome.

(B) Relic prophage WO regions, such as in the phage regions of WORecB and WOAlbB, likely arose by invasion of a fully intact phage WO, chromosome integration, and erosion over time that led to loss of structural genes and the inability to form phage particles. In a process termed domestication, Wolbachia may retain selected, phage-associated genes for adaptive functions such as CI encoded by the cifA and cifB genes and MK encoded by the candidate gene wmk. (C) Genomic maps of the newly discovered pWCP plasmid in the wPip Wolbachia strain of mosquitoes and the wMel chromosome from flies with its two integrated prophages, WOMelA and WOMelB. Prophage regions are highlighted in light gray on the Wolbachia chromosome, phage structural genes are in dark gray, and key reproductive parasitism genes, cifA;cifB (pink) and wmk (blue) are highlighted in their respective colors within the EAM. pWCP and phage WO are absent in the nematode Wolbachia.

(Table S1), and recently, over one thousand more Wolbachia genomes from different arthropod and nematodes species have been assembled (Scholz et al., 2020). Using this increasing array of Wolbachia genomes, comparative analyses identified strainspecific differences, significant genes involved in altering host biology, and evolutionary relationships at a genome level (Ishmael et al., 2009; LePage et al., 2017; Newton et al., 2016; Perlmutter et al., 2019; Rice et al., 2017).

Wolbachia’s pangenome is subdivided into a typical core of genes shared by all sequenced strains and a variable accessory set of genes that contribute to considerable genome size variation (size range: 1.2–1.8 Mb, complete genomes only, Table S1). Strictly vertically inherited Wolbachia that are mutualistic in nematodes have a genome size ${ \sim } 3 0 \%$ smaller (size range: 0.96–1.1 Mb) than those that are parasitic in arthropods, which occasionally host-switch and often uptake mobile elements such as bacteriophage WO, transposons, and plasmids (see mobilome section below). Using microarray-based comparative genomic hybridization, a large number of accessory and rapidly evolving genes were identified, especially in prophage WO regions among closelyrelated Wolbachia supergroup A strains (Ishmael et al., 2009). Understanding the functional and adaptive significance of changes in genome size and accessory gene number remains a nascent, but exciting effort to ultimately resolve the general direction of evolution in Wolbachia genome size, along with the selective pressures and host-Wolbachia interaction processes that drive these changes.

# MOBILOME: THE MASTER MANIPULATOR PHAGE WO, TRANSPOSONS, AND A PUTATIVE PLASMID

# Phage WO

Phage WO occurs in the genomes of at least five Wolbachia supergroups including A, B, E, F, and S (Bordenstein and Wernegreen, 2004; Gerth et al., 2014; Kampfraath et al., 2019; Lefoulon et al., 2020; Vaishampayan et al., 2007) (Figure 1B; Table S2). The known majority occurs and frequently exchanges within the A and B supergroups in arthropods. Phage WO is temperate and thus exists in two states: lytic phage particles and lysogenic prophages that are stably integrated into and replicate with the Wolbachia chromosome (Figure 2A). When phage WO enters the lytic lifecycle to copy and disperse itself, the particles assemble into standard phage structures including an icosahedral head with a short tail (Bordenstein et al., 2006; Masui et al., 2001). During lysis, phage WO particle production corresponds with canonical features of bacterial lysis including the breakage of cell membranes and degradation of DNA, leading to Wolbachia death and an acute lytic event that releases numerous WO progenies at once (Bordenstein et al., 2006; Masui et al., 2001). Relic prophage WO, defined as truncated or mutated prophages in Wolbachia genomes, are most likely not capable of producing particles (Figure 2B). Relic phage can however be advantageous for the bacteria because their remaining genes can still produce protein products, such as prophage WO-encoded accessory genes for cytoplasmic incompatibility (cif) and male killing (wmk) (Beckmann et al., 2017; LePage et al., 2017; Perlmutter et al., 2019) found in the eukaryotic association module (EAM) (Figure 2C).

![](images/056ffe7fcd9cce65fbbc69bf0c2186a72681426cfc15ac0fca58f79ac07276c7.jpg)  
Figure 3. Wolbachia tissue tropism in arthropods and nematodes   
(A) Somatic and reproductive tissues with Wolbachia are labeled in the arthropod host Drosophila and nematode host Brugia malayi. (B) During Drosophila oogenesis, Wolbachia (red) are present in germline stem cells where cell differentiation gives rise to a Wolbachia-infected egg ch composed of an oocyte and nurse cells that interconnect by ring canals. During early oogenesis, Wolbachia utilize microtubules to move into the oocyte. They localize to the posterior pole during mid oogenesis and remain throughout development in the mature egg. (C) During Drosophila spermatogenesis, Wolbachia are present in the germline stem cells, which divide mitotically to give rise to 16 interconnected spermatocytes with unevenly distributed Wolbachia. The spermatocytes then undergo meiosis to create a 64-cell cyst of interconnected spermatids that undergo elongation and individualization. During individualization, excess cytoplasmic components including Wolbachia are removed from the mature sperm into a cytoplasmic waste bag.

Phage WO’s EAM constitutes approximately $3 0 \% { - } 7 0 \%$ of the phage genome. Its genomic composition varies across prophage WO variants and encompasses proteins with domains such as ankyrins, a latrotoxin C-terminal domain, which is a crucial component of the black widow spider venom, and NACHT domains that signal programed cell death (Bordenstein and Bordenstein, 2016). Though the origin of EAM genes remains to be fully resolved, evidence suggests multiple, previously undescribed horizontal gene transfer events between arthropod hosts and phage WO (Bordenstein and Bordenstein, 2016). The direction of transfer is not necessarily unidirectional, with WO genes identified in uninfected Chorthippus parallelus grasshoppers (Funkhouser-Jones et al., 2015). Thus, two-way transfer of DNA between phages and animal hosts is an area ripe for further investigation and discovery.

# Transposons

The genomes of Wolbachia harbor a high frequency of transposable elements, including many insertion sequences that can occupy up to $10 \%$ of the bacterial genome (Cordaux et al., 2008; Ling and Cordaux, 2010). Group II introns that are selfsplicing, mobile ribozymes are also exceptionally abundant in Wolbachia relative to both endosymbiotic and free-living bacterial genomes; they can be involved in Wolbachia genomic rearrangements and extensive horizontal gene transfers (Leclercq et al., 2011). Transposable elements generally cause a large amount of bacterial genome variability and have proven very useful for discriminating very closely-related strains of Wolbachia (Duron et al., 2005; Kaur et al., 2017). They also play roles in the evolution of Wolbachia genomes by disrupting genes such as wspB (Sanogo et al., 2007) and by potentially assisting the movement of cifA and cifB genes within or between Wolbachia genomes (Cooper et al., 2019).

# Putative plasmid

The putative plasmid pWCP (plasmid of wPip Wolbachia in C. pipiens mosquitoes) (Reveillaud et al., 2019) is a circular element spanning 9.23 kb of DNA with 15 genes including an IS110 transposable element and an intergenic repeat region (IRR) (Figure 2C). pWCP is present in natural populations and from publicly available metagenomes of C. pipiens from multiple countries, suggesting this extrachromosomal element is a natural member of the wPip mobilome. As pWCP is the first putative Wolbachia plasmid discovered to date, its distribution across the Wolbachia phylogeny remains to be determined. While novel in Wolbachia, plasmids are common in the closely-related Rickettsia genus (El Karkouri et al., 2016) and contain genes that are often present in prophage WO genomes (Ishmael et al., 2009). Additional extrachromosomal elements are likely to be discovered in the Wolbachia mobilome.

# CELL BIOLOGY OF WOLBACHIA

# Tissue tropism

Wolbachia inhabit the cells of both reproductive and somatic tissues in arthropods and nematodes (Figure 3A). The main transmission route for Wolbachia is vertical through female’s ovaries to developing eggs. Although males harbor Wolbachia, they do not transmit the bacteria except in rare cases. In filarial nematodes, Wolbachia also transmit transovarially, but they do not invade the male germline and may thus respond to signaling molecules in the female germline only (Foray et al., 2018; Landmann et al., 2012).

In Drosophila ovaries, as germline stem cells differentiate, Wolbachia randomly distribute via microtubules to inhabit both nurse cells and oocytes, through a series of cytoplasmic bridges known as ring canals (Ferree et al., 2005). Wolbachia navigate between the two sites as the mature eggs develop, ultimately localizing to the posterior end of the oocyte to ensure germline-based transmission (Figure 3B) (Serbus et al., 2008). Posterior enrichment of Wolbachia in D. melanogaster, as well as in filarial nematode B. malayi, relies on microtubule-based motor proteins such as dynein and kinesin (Ferree et al., 2005; Landmann et al., 2014). Wolbachia also utilize the actin cytoskeleton to facilitate their maternal transmission. In Drosophila, mutants of actin regulatory proteins ablate this function (Newton et al., 2015) and in nematodes, actin association is weak during somatic to germline transmission of the symbiont (Landmann et al., 2012). A Wolbachia protein named toxic manipulator of oogenesis (TomO) interacts with nanos mRNA in Drosophila ovaries to enhance the maintenance and proliferation of germline stem cells (Ote et al., 2016).

In the male germline of D. melanogaster and D. simulans, Wolbachia localize and concentrate at the apical tip of the testes during early spermatogenesis (Figure 3C) (Clark et al., 2002) and reside within the cytoplasm of the developing spermatocytes. Following meiotic divisions, the 16 spermatocytes produce a cyst of 64 interconnected spermatids, which are elongated with a decrease in nuclear volume. Spermatids then undergo an individualization process that strips the ring canals, cytoplasm, Wolbachia, and other unnecessary organelles into a waste bag for eventual degradation (Riparbelli et al., 2007). This purging results in elimination of Wolbachia from the mature sperm that typically does not transfer to the embryo.

Somatic distribution of Wolbachia is restricted to the hypodermis, pseudocoelom, and intestine in both sexes of filarial nematodes. In arthropods, Wolbachia are found in various tissues such as the gut, malpighian tubules, fatbody, brain, and head and thoracic muscles among other tissues (Figure 3A) (Pietri et al., 2016). Although various studies have revealed the functional relevance of Wolbachia somatic infection (Pietri et al., 2016), understanding the significance and persistence of somatic cell localization to Wolbachia fitness remains largely unexplored.

# Vertical and horizontal transmission

Wolbachia’s success is attributable in part to efficient vertical transmission through the female germline. However, cases of imperfect maternal transmission have also been detected (Hague et al., 2020). Factors that impact vertical transmission include Wolbachia densities, ability to migrate into the oocyte, and interactions with other symbionts (Mouton et al., 2004). Indeed, low bacterial densities can result in stochastic loss of Wolbachia in developing oogonia, limiting transfer to the next generation. However, high densities in excess of what is required for successful maternal transmission can lead to a reduced lifespan in flies (Min and Benzer, 1997) and fecundity in wasps (Chafee et al., 2011). Selection for host responses led to the evolution of the wasp gene Wds that suppresses the maternally transmitted densities of Wolbachia (Funkhouser-Jones et al., 2018). Therefore, a balance of vertical transmission of Wolbachia with optimum densities is important for a long-term, stable endosymbiosis.

Phylogenomic analyses suggest numerous host-switching events among arthropods and ancient exchanges between arthropods and nematodes. Horizontal acquisition of Wolbachia occurs in the lab or field via cannibalism and predation of infected individuals (Le Clec’h et al., 2013), parasitism (Heath et al., 1999), hybrid introgression (Raychoudhury et al., 2009; Turelli et al., 2018), and shared ecological niches (Li et al., 2017). Collectively, diverse routes of horizontal transmission raise several intriguing questions such as: do Wolbachia have an extracellular stage that permits high rates of horizontal transmission, how often do Wolbachia move between hosts, and how often are the host-switching events successful?

# WOLBACHIA PHENOTYPES: GENES AND MECHANISMS

# Cytoplasmic incompatibility

The most prevalent and commonly described Wolbachiainduced reproductive phenotype in arthropods primarily occurs in two forms: unidirectional cytoplasmic incompatibility (CI) and bidirectional CI (Shropshire et al., 2020a). Unidirectional CI results in embryonic death in crosses between infected males and uninfected females (Figure 4A), whereas bidirectional CI results in embryonic death between males and females harboring reciprocally incompatible Wolbachia strains. At the cytological level, male and female pronuclei in CI embryos often fail to synchronize at the initial stage of mitosis. Embryos experience a delay in male nuclear envelope breakdown and histone H3 phosphorylation (a histone modification that is required for the initiation of mitosis), which then delays the activity of Cdk1, a key kinase that drives the cell into mitosis (Tram and Sullivan, 2002). As a result, female chromosomes separate normally during anaphase, whereas male chromosomes often undergo chromatin-bridging defects and improper segregation, resulting in embryonic arrest during early embryogenesis (Landmann et al., 2009).

The genetic basis of Wolbachia-induced CI is governed by a two-by-one genetic model in D. melanogaster (Shropshire and Bordenstein, 2019), whereby male expression of two genes, cifA and cifB, cause CI (Beckmann et al., 2017; LePage et al., 2017), and female expression of cifA rescues CI (Shropshire et al., 2018) (Figure 4A). Cif and Cif-like protein diversity has been qualified into five phylogenetic types (LePage et al., 2017; Lindsey et al., 2018; Martinez et al., 2021). Evolutionarily guided mutagenesis of conserved sites in the CifA protein identified functional roles in CI alone or both CI and rescue (Shropshire et al., 2020b). Similar analyses in CifB reveal protein-wide conserved sites that are crucial for CI induction (Beckmann et al., 2017; Shropshire et al., 2020b). Combinatorial, transgenic analyses of CI and rescue using cif type I and II homologs reveal that the cifA variants generally contribute to strong transgenic CI and interchangeable rescue, whereas cifB variants contribute to weak or no CI phenotypes (Shropshire et al., 2021). Interestingly,

![](images/1e4974aa3b35398094333ea97a64965aff24dc781c0993c0f917ba4023fe6721.jpg)  
Figure 4. Reproductive phenotypes in arthropods

Wolbachia induce four, well-established reproductive parasitism phenotypes that assist its spread in a range of arthropod hosts.   
(A) Cytoplasmic incompatibility (CI) causes embryonic death in crosses between infected males and uninfected females. In D. melanogaster males, expression of Wolbachia (red dots) prophage WO genes, cytoplasmic incompatibility factors (cif) cifA and cifB, causes CI and results in embryonic death. Female expression of cifA in Wolbachia-infected eggs rescues the CI phenotype, leading to normal development of embryos.   
(B) Male killing results in a female-biased sex ratio in various arthropods by selectively killing males. In D. melanogaster, transgenic expression of candidate gene wmk in the embryos causes partial, male-specific embryonic lethality.   
(C) Parthenogenesis causes virgin mothers to produce all female offspring from their unfertilized eggs. In Trichogramma wasps, Wolbachia in the unfertilized eggs double the haploid set of maternal chromosomes, causing them to develop into diploid females.   
(D) Feminization results in genetic males that phenotypically develop as females. The molecular mechanism of feminization is unknown; however, on an evolutionary scale, Wolbachia inserted a fragment of their DNA called ‘‘f element’’ into the pill bug host genome that effectively resulted in the evolution of a new female sex-determining chromosome.

CI induction by co-expression of non-cognate cifA and cifB homologs support a similar mechanism of Cif-induced CI across the divergent lineages (Shropshire et al., 2021). Moreover, several host factors and genes linked to CI have been described (Shropshire et al., 2020a). Future cellular studies will be important to empirically determine their role in CI biology.

# Male killing

Male killing (MK) is a form of reproductive parasitism in which Wolbachia selectively kill developing, infected males, resulting in female-biased sex ratios in the arthropod hosts (Figure 4B). Wolbachia-induced MK was first discovered in the ladybird species Adalia bipunctata and the butterfly species Acraea encedon (Hurst et al., 1999). In Drosophila, the earliest case of MK Wolbachia was reported in D. bifasciata (Hurst and Jiggins, 2000). Various lines of evidence indicate that MK Wolbachia target developing males by hijacking the dosage compensation system that upregulates expression of male sex-chromosome-linked genes. For instance, in the moth Ostrinia furnacalis, MK Wolbachia prevent dosage compensation by downregulating the masculinizer gene required for both masculinization and dosage compensation in males (Fukui et al., 2015).

A candidate MK gene was identified in the EAM region of Wolbachia prophage WO, termed WO-mediated killing (wmk) from wMel Wolbachia (Figure 4B) (Perlmutter et al., 2019). wmk expression causes male-specific lethality during early embryogenesis and cytological defects typical of the pathology of MK, including chromatin-bridging, pyknotic nuclei and mitotic failure. Moreover, embryonic death is linked to DNA damage associated with dosage compensation. The wmk gene occurs in all sequenced Wolbachia MK strains and is unique to Wolbachia, suggesting that the Wolbachia MK may have independent mechanisms in comparison with Spiroplasma MK. Questions for future research span whether or not the dosage compensation complex is directly involved in Wolbachia-mediated MK, where the Wmk protein localizes, and how wmk sequence variation impacts MK.

# Feminization

Another sex ratio modification strategy used by Wolbachia is feminization, whereby genetic males morphologically develop into females (Figure 4D). The best-studied example of Wolbachia-induced feminization is the pillbug, Armadillidium vulgare (Rigaud et al., 1991). In A. vulgare, male sex differentiation is triggered by an androgenic hormone secreted by the androgenic gland. Wolbachia proliferate within the gland and may inhibit the secretion of androgenic hormone, developmentally forcing genetic males into morphological females (Bouchon et al., 2008). The Wolbachia strain wVulC feminizes its natural host A. vulgare as well as its artificially transinfected isopod host Cylisticus convexus, whereas the closely related and naturally occurring wCon strain causes CI in its native host C. convexus. Using comparative ‘omics, two genes present in the Wolbachia prophage WO region (wVul_1408 and wVul_1821) are of particular interest in feminization, since they are differentially expressed when wVulC is in either A. vulgare or C. convexus (Badawi et al., 2018). It remains unknown if these genes are responsible for Wolbachia-induced feminization or how/if they interact with host factors. Future work including functional genetic analyses will be necessary to determine the direct causative relationship of Wolbachia-induced feminization and to understand the complexity of its mechanism.

# Parthenogenesis

Wolbachia-induced parthenogenesis occurs in several species of hymenopteran wasps, thysanopteran thrips, and trombidiformes mites (Ma and Schwander, 2017). In the absence of Wolbachia, these species typically exhibit arrhenotokous parthenogenesis due to their haplodiploid sex determination system. However, Wolbachia-infected virgin mothers produce all female offspring from their unfertilized eggs instead of males (Figure 4C), thus switching from arrhenotokous to thelytokous parthenogenesis. Wolbachia in Trichogramma induce thelytoky by a mechanism of chromosomal endoduplication in which unfertilized eggs undergo diploidization in the first mitotic division as the haploid chromosome set is duplicated but fails to fully separate during anaphase. Mitotic divisions following this event are normal, resulting in the development of diploid, Wolbachiainfected, female offspring (Figure 4C).

To identify the genetic basis of parthenogenesis, a comparative genomic analysis was performed using the wUni strain of M. uniraptor and the closely related CI-inducing wVitA strain from N. vitripennis. This revealed significant rearrangements, protein truncations, and elevated substitution rates in the wUni genome (Newton et al., 2016). Similarly, comparative genomics of the wTpre genome of T. pretiosum determined truncations in $20 \%$ of the protein coding sequences (Lindsey et al., 2016) including in the genes subsequently identified to cause CI. Truncation of CI genes might have resulted in the shift from CI to PI lifestyle of the wTpre strain (Lindsey et al., 2016; Newton et al., 2016). Recent work on the T. pretiosum epigenome showed Wolbachia-mediated altered splicing of various host genes involved in oocyte development, meiosis, and cell division (Wu et al., 2020). Functional genetic studies performing knockdown of target host gene expression will be useful to interrogate the contribution of particular proteins underpinning Wolbachiainduced parthenogenesis.

# Pathogen resistance

Wolbachia can reduce pathogenic viral loads in various arthropod species. This phenotype was initially discovered in the wMel strain of Wolbachia in D. melanogaster (Hedges et al., 2008; Teixeira et al., 2008). In mosquitoes, Wolbachia can limit the replication of viruses in various somatic tissues such as midgut and salivary glands, making them less capable of transmitting infection to humans (Ogunlade et al., 2021). Wolbachia can also confer resistance against bacteria, filarial nematodes, and the malaria parasite Plasmodium (Bourtzis et al., 2014), providing a broad range of pathogen protection.

Higher Wolbachia densities within hosts is often important for an effective antiviral response (Chrostek et al., 2013) with a few exceptions (Cattel et al., 2016; Kaur et al., 2020). At the cellular and molecular levels, Wolbachia can confer virus blocking by inhibiting viral binding, entry into the cell, and RNA replication in the early stages (Schultz et al., 2018; Lu et al., 2020). Such blocking reduces the production of progeny viruses from the same Wolbachia-infected cells and consequently limits virus dissemination and transmission (Bhattacharya et al., 2020).

Certain host factors also play a role in Wolbachia-virus dynamics. Overexpression of methyltransferase gene, aaDnmt2, inhibits Wolbachia replication and promotes dengue virus replication in the mosquito host (Zhang et al., 2013). In Drosophila, however, expression of Dnmt2 is induced in the presence of Wolbachia and provides antiviral defense (Durdevic et al., 2013; Bhattacharya et al., 2017, 2020). A comprehensive RNA sequencing (RNA-seq) analysis revealed that prat2 gene involved in de novo synthesis of purine nucleotides upregulates in Wolbachia-infected flies; knockdown of prat2 mRNA levels shows a Wolbachia-dependent impact on viral replication, with knockdown being pro-viral in the presence of Wolbachia and antiviral in the absence of Wolbachia (Lindsey et al., 2020). Functional metabolic and proteomic assays will be essential to connect transcriptomic changes to downstream events that eventually result in Wolbachia-conferred pathogen-blocking phenotype.

Wolbachia can also upregulate the expression of genes involved in innate defense pathways and prime the insect innate immunity to block pathogen replication (Kambris et al., 2010). However, Drosophila species that are naturally infected with Wolbachia do not show an immune-priming phenotype yet confer antiviral activity (Wong et al, 2011), suggesting that such innate immune priming only occurs in hosts with artificially transinfected Wolbachia strains (Rance\` s et al., 2012) or recently introduced host-Wolbachia associations. Thus, it cannot explain the entirety of the effect.

# Obligatory and facultative mutualisms

Obligate mutualisms between Wolbachia and their hosts, whereby both partners seem to benefit, are also common (Fenn and Blaxter, 2004). In B. malayi nematodes, Wolbachia are unable to perform de novo synthesis of several vitamins and cofactors such as coenzyme A, biotin, folate, etc. (Foster et al., 2005), rendering them metabolically dependent on their nematode hosts. On the other hand, elimination of Wolbachia via antibiotics impairs the normal development, fertility, and vitality of adult filarial worms (Coulibaly et al., 2009), suggesting host/ dependency on Wolbachia. Wolbachia genome analysis from B. malayi (Foster et al., 2005) and the bovine tissular filariid Onchocerca ochengi (Darby et al., 2012) revealed that Wolbachia contain various genes required for heme metabolism and riboflavin essential for survival and fecundity of their host. Nevertheless, how transport, degradation and regulation of heme occurs within filarial hosts remains an open question.

In a few arthropods, Wolbachia can act as an obligate mutualist. In the parasitic wasp Asobara tabida, antibiotically cured females fail to develop eggs (Dedeine et al., 2001). In the bedbug Cimex lectularius, reduction or elimination of Wolbachia through antibiotic treatment renders abnormal development of eggs, which can be restored by dietary supplementation of vitamin B and biotin (Nikoh et al., 2014), suggesting a coadaptive process similar to the nematode-Wolbachia association. Wolbachia also act as facultative mutualists whereby hosts benefit from the bacteria, but they do not depend on Wolbachia for survival or fecundity. For instance, Wolbachia increase the fecundity of D. melanogaster flies under varying levels of iron, suggesting that Wolbachia may be altering host iron metabolism as a nutritional mutualist (Brownlie et al., 2009). Wolbachia also enhance longevity, fitness, and fertility of flies and mosquitoes. It remains unclear what is the molecular mechanism behind facultative mutualism and how common this phenomenon is among other arthropods.

# EVOLUTIONARY IMPLICATIONS OF HOST-WOLBACHIA ASSOCIATIONS

# Wolbachia-driven evolution of host genomes

There is a genetic conflict between the biparental inheritance of host genes and the uniparental inheritance of maternally transmitted Wolbachia that increase their transmission through females. In response to the selective pressures exerted on hosts by Wolbachia functions, hosts may counteradapt and resist. For instance, wMel Wolbachia cause variable levels of CI in their native host D. melanogaster but induce consistently strong CI when artificially introduced into other hosts such as D. simulans and A. aegypti (Poinsot et al., 1998; Walker et al., 2011), suggesting that long-term-associated hosts evolved resistance. Similarly, Hypolimnas bolina butterflies, A. vulgare pillbugs, and T. kaykai wasps evolved resistance to MK (Mitsuhashi et al., 2011), feminization (Rigaud and Juchault, 1992), and parthenogenetic Wolbachia (Stouthamer et al., 2001), respectively. While the mechanisms of host resistance to reproductive parasitism are currently unknown, their evolution is a legacy of the layers of selection and conflicts that exist between maternally transmitted Wolbachia and their biparentally inherited host genome.

Additionally in some lines of A. vulgare isopods, the ‘‘f element’’—a horizontally transferred Wolbachia insert in the host isopod genome—is present on an autosome and responsible for female sex determination (Figure 4D) (Badawi et al., 2018; Cordaux and Gilbert, 2017). The f element contributes to feminization in the absence of Wolbachia and results in the emergence of a novel W-like chromosome necessary for female heterogamety (Figure 4D) (Leclercq et al., 2016). In summary, feminizing Wolbachia may contribute to the turnover of sex chromosomes where a ZW/ZZ is converted to symbiont-driven sex determination system and then back to a ZW/ZZ-like system that may be dependent on a different set of mechanisms for sex determination. It will be important to understand the nature and mechanisms of the f element, whether feminizing Wolbachia in ZW/ZZ systems commonly have this impact on the evolution of their host’s sex determination, and whether XX/X0 systems suffer comparable, cascading consequences.

# Impact of Wolbachia on host speciation

With marked impacts on gametogenesis and embryogenesis, Wolbachia-induced CI is a notable example whereby bacterial symbionts reduce nuclear gene flow between populations or incipient species in the absence of host genetic divergence or geographic isolation (Shropshire et al., 2020a). Moreover, Wolbachia-induced parthenogenesis or asexual reproduction can also cause RI because it effectively makes gene flow unnecessary (Shropshire and Bordenstein, 2016). Its effectiveness depends largely on how frequently or infrequently asexual-capable populations interbreed with sexual populations (Elias-Costa et al., 2019). If mating is frequent, then gene flow will continue and reduce the effect of parthenogenesis on RI. However, asexual reproduction may also be accompanied by the loss of sex-specific traits due to sexual degeneration or relaxed sexual selection (Gottlieb and Zchori-Fein, 2001; Stouthamer et al., 2010). Wolbachia may also have subtle impacts on RI through environmental changes or host mate preference behaviors (Miller et al., 2010). Future work in additional systems can shed light on how common symbiont-assisted speciation is across the diversity of arthropods (Brucker and Bordenstein, 2012).

# Gene transfers between host and Wolbachia

The intimate associations between host and intracellular Wolbachia frequently lead to lateral gene transfers (LGTs) between their genomes (Dunning Hotopp et al., 2007). In beetles, Wolbachia genomic fragments are transferred to the X chromosome and autosome of the host (Aikawa et al., 2009). The transferred genes are, however, pseudogenized and likely derived from a single LGT. In D. ananassae, multiple copies of an entire Wolbachia genome occur in the fourth chromosome (Dunning Hotopp et al., 2007). In the tsetse fly Glossina morsitans morsitans, two large Wolbachia genome insertions are in the host X and Y chromosomes (Brelsfoard et al., 2014). In two meadow grasshopper subspecies, Chorthippus parallelus erythropus and C. parallelus parallelus, recent and large gene transfers from two different Wolbachia supergroups (B and F) occurred, revealing some inserts are subspecies specific while others are present in both subspecies (Funkhouser-Jones et al., 2015). The functional significance of LGTs, if any, is an important topic of future investigation, namely, to determine if the transferred genes impact phenotypes and contribute to host fitness and processes such as speciation or adaptation.

![](images/4ae2eb6bdca5f3a8a61be894aa4f6299a9db76076f3f629c1860ca057a43de4e.jpg)  
Figure 5. Wolbachia-mediated applications to control insect vectors   
(A) Population replacement strategy commences with release of both male and female mosquitoes where CI-inducing Wolbachia spread throughout uninfected target populations, thus replacing the native species with pathogen-resistant, Wolbachia-infected mosquitoes that are no longer capable of transmitting disease. (B) Incompatible insect technique entails release of CI-causing Wolbachia-infected male mosquitoes that do not produce viable embryos after mating with wildtype uninfected females, thus reducing the total number of disease-transmitting mosquitoes in natural populations. Figure is adapted from Yen and Failloux (2020).

# APPLICATIONS OF WOLBACHIA FOR CURBING HUMAN DISEASES

# Population replacement strategy

Population replacement strategy (PRS) leverages two aspects of Wolbachia to curb mosquito-borne viral diseases—pathogen blocking and CI drive. A. aegypti mosquitoes, the vector of many human pathogenic viruses including dengue, chikungunya, and Zika viruses, do not naturally carry Wolbachia (Kittayapong et al., 2000). Stable and heritable Wolbachia infections such as wAlbB from A. albopictus (Xi et al., 2005) and wMelPop and wMel from D. melanogaster (McMeniman et al., 2009; Walker et al., 2011) have been successfully established in this species by artificial transinfection. Using CI-based drive, Wolbachia-infected mosquitoes released into the wild replace an otherwise uninfected population, reduce their vector competence, and curb the arboviral disease burden in humans (Figure 5A). Various studies have now demonstrated population replacement in several countries including Australia, Indonesia, Brazil, Colombia, Fiji, Kiribati, India, China, Mexico among others and reduced cases of dengue transmission (Flores and O’Neill, 2018; Joubert et al., 2016; Indriani et al., 2020; Nazni et al., 2019; Ryan et al., 2019). Furthermore, the wStri Wolbachia strain was recently stably introduced into the brown planthopper Nilaparvata lugens, a destructive agricultural pest, to inhibit the infection and transmission of rice tagged stunt virus that damages rice crops (Gong et al., 2020). These studies show that PRS can drive Wolbachia to high frequencies and successfully reduce the vectoral capacity of arthropods. Notably, although at the early stages of development, there are efforts to extend the efficacy of PRS using vertically transmitted, insect-specific viruses that, like Wolbachia, inhibit arboviral replication (Parry and Asgari, 2018).

# Incompatible insect technique

Incompatible insect technique (IIT) relies on a key component of Wolbachia-induced CI, namely that Wolbachia-infected males cause embryonic lethality after mating with uninfected females (Laven, 1967). Thus, release of Wolbachia-infected males suppress the mosquito population size in the field (Figure 5B), as achieved in China (wPip, wAlbB, and wAlbB in A. aegypti), Italy, Singapore, and America (wPip in A. albopictus and wAlbB in A. aegypti) (Caputo et al., 2020; Mains et al., 2019; Puggioli et al., 2016; Zheng et al., 2019). Work is in progress to expand IIT to control other vectors and pests, including the fruit pest Ceratitis capitata and protozoan vector C. quinquefasciatus.

# Genetic manipulation of Wolbachia

Genetic editing of Wolbachia would expand vector control efforts as insertion of genes into the genome for pathogen blocking or increased penetrance of CI could serve an alternative or adjunct to current efforts. While some success has been reported using random mutagenesis to introduce genetic variation in the Wolbachia genome (Duarte et al., 2020), mutant identification and linkage with a Wolbachia-conferred phenotype remains a challenge. Wolbachia do not replicate outside of their host cells and are not yet genetically editable (Rasgon et al., 2006); thus, efforts to investigate cellular factors required for Wolbachia growth and replication in the host-cell-free system are impending (Krafsur et al., 2020).

Genetic transformation of closely-related Rickettsia endosymbionts has been achieved using transposon mutagenesis (Qin et al., 2004). The same methodology can possibly be optimized for Wolbachia transformation in the future. Additionally, a metagenomic analysis of Wolbachia-encoded phage WO particles uncovered phage WO and Wolbachia attachment sequences as well as bacterial integration sites that are in development as a potential tool for gene insertions into Wolbachia (Bordenstein and Bordenstein, 2016). Moreover, plasmids are commonly used in genetic engineering and gene therapy research to alter genomes and phenotypes. As such, discovery of the aforementioned plasmid pWCP in wPip (Reveillaud et al., 2019) could enable development of a new genetic tool and applications for controlling arthropods or filarial nematode-associated animal and human diseases.

# Anti-Wolbachia drug therapy for curing filarial diseases

Wolbachia occur in mutualistic relationships with many species of filarial nematode worms, which cause diseases such as river blindness, lymphatic filariasis, and heartworm (Slatko et al., 2014). Since elimination of Wolbachia can halt the worm’s life cycle, Wolbachia serve as a compelling drug target for treating human filariasis (Taylor et al., 2005). A high throughput drug screening approach was undertaken by A-WOL (https://awol. lstmed.ac.uk), an international consortium assembled to identify anti-Wolbachia compounds. Several drug candidates were uncovered including doxycycline and minocycline that can deplete Wolbachia by more than $9 9 \%$ (Johnston et al., 2014). However, lengthy treatments and restrictions against usage in children and pregnant women pose challenges to widespread implementations. Recent testing of a new, orally available antibiotic, tylosin A analog, A-1574083, showed robust anti-Wolbachia activity with a short treatment time frame of 7 to 14 days (Taylor et al., 2019). Thus, A-1574083 may provide clinical benefits with a shorter dosing regimen. Moreover, in order to enhance the drug specificity toward Wolbachia, a novel synthetic molecule, AWZ1066S, has been designed that confers minimal impact on the gut microbiota and shows superior efficacy to existing antiWolbachia therapies in preclinical trials (Hong et al., 2019). Overall, discovery of anti-filarial drugs has consistently shown the potential to be prophylactic, curative, and macrofilaricidal to reduce the disease pathology. Additionally, alternative methods may one day include phage WO therapy to specifically target Wolbachia in filarial infections, whereby phage WO particles or phagederived enzymes could be developed to lyse Wolbachia cells with high specificity (Bordenstein et al., 2006).

# DISCOVER THE MICROBES WITHIN! THE WOLBACHIA PROJECT: AN ARCHETYPE FOR STUDENT-DRIVEN AND CITIZEN SCIENTIST DISCOVERIES

The multidisciplinary, biotechnology lab series ‘‘Discover the Microbes Within! The Wolbachia Project’’ (https://vu.edu/ wolbachia) empowers students, teachers, and scientists to take ownership of their science, learn major concepts in biology, and make novel scientific contributions in a culture of excellence (Lemon et al., 2020). The project integrates genetics, entomology, evolution, molecular biology, and bioinformatics techniques to engage participants internationally. Implementation of the labs is facilitated by partnerships with the Wolbachia scientific community, online digital and social media resources, downloadable labs and lectures, a free loaner equipment program, and a DNA sequencing partnership.

The end products of this lab research series are new discoveries of Wolbachia infections and DNA sequences, and the broad core goals of the project are to (1) engage students in nature and real-world research, (2) encourage international participation in the collection of new scientific data on bacterial endosymbionts (Wolbachia), (3) enhance student interest in science through an integrative lab series spanning biodiversity to molecular biology, and (4) give students an idea of what it is like to be a scientist. As biologists and students continue to appreciate the dominance of the microbial and symbiotic worlds in the macrobiological biosphere, the story of Wolbachia will serve as a foundational blueprint for science education as well as human health applications.

# CONCLUDING REMARKS

Advances in multiomics, gene functional assays, and human health applications in the field have spurred rapid and fundamental insights that will undoubtedly be covered in textbooks covering symbiosis. Several key questions for the future include: what are the biochemical and mechanistic bases of reproductive parasitism and pathogen blocking? Can Wolbachia be genetically manipulated to ultimately advance reductionist, functional studies of Wolbachia gene products? Will Wolbachia studies and therapies continue to soften the global burden of human diseases such as filarial infections and arboviruses? What are the evolutionary trajectories of Wolbachia infections within and between species? Do Wolbachia promote speciation in numerous systems? Significant progress is now likely to be made in this field, which makes the next century of Wolbachia research a more exciting and impactful one to the life sciences. What was once a curiosity to Hertig and Wolbach is now an archetype for microbial symbiosis and an exemplar for how basic science leads to positive, translational, and educational outcomes.

# SUPPLEMENTAL INFORMATION

Supplemental information can be found online at https://doi.org/10.1016/j.   
chom.2021.03.006.

# ACKNOWLEDGMENTS

This work was supported by National Institutes of Health (NIH) awards R01 AI132581 and R01 AI143725, National Science Foundation (NSF) award IOS 1456778, and the Vanderbilt Microbiome Initiative to S.R.B., a NSF graduate research fellowship DGE-144519 and postdoctoral research fellowship DBI2010210 to J.D.S., a NIH Ruth Kirschstein Postdoctoral Fellowship to B.A.L. Any opinion, conclusions, or recommendations expressed in this material are those of the authors(s) and do not necessarily reflect the views of the National Institutes of Health, the National Science Foundation, or Vanderbilt University. Majority of the figures are created with Biorender.com. We thank Emily Layton in contributing to the Figure 2 illustration. We thank Dr. Richard Cordaux for providing useful feedback on Figure 4D. We deeply apologize to the authors whose work could not be cited due to citation number restrictions.

# AUTHOR CONTRIBUTIONS

All authors contributed to the text of the article. R.K. and S.R.B. performed all of the editing and wrote the final version.

# REFERENCES

Aikawa, T., Anbutsu, H., Nikoh, N., Kikuchi, T., Shibata, F., and Fukatsu, T. (2009). Longicorn beetle that vectors pinewood nematode carries many Wolbachia genes on an autosome. Proc. Biol. Sci. 276, 3791–3798.

Badawi, M., Moumen, B., Giraud, I., Gre\` ve, P., and Cordaux, R. (2018). Investigating the molecular genetic basis of cytoplasmic sex determination caused by Wolbachia endosymbionts in terrestrial isopods. Genes (Basel) 9, 290.

Baldo, L., Dunning Hotopp, J.C.D., Jolley, K.A., Bordenstein, S.R., Biber, S.A., Choudhury, R.R., Hayashi, C., Maiden, M.C.J., Tettelin, H., and Werren, J.H. (2006). Multilocus sequence typing system for the endosymbiont Wolbachia pipientis. Appl. Environ. Microbiol. 72, 7098–7110.

Bandi, C., Anderson, T.J., Genchi, C., and Blaxter, M.L. (1998). Phylogeny of Wolbachia in filarial nematodes. Proc. Biol. Sci. 265, 2407–2413.

Beckmann, J.F., Ronau, J.A., and Hochstrasser, M. (2017). A Wolbachia deubiquitylating enzyme induces cytoplasmic incompatibility. Nat. Microbiol. 2, 17007.

Bhattacharya, T., Newton, I.L.G., and Hardy, R.W. (2017). Wolbachia elevates host methyltransferase expression to block an RNA virus early during infection. PLoS Pathog. 13, e1006427.

Bhattacharya, T., Newton, I.L.G., and Hardy, R.W. (2020). Viral RNA is a target for Wolbachia-mediated pathogen blocking. PLoS Pathog. 16, e1008513.

Bleidorn, C., and Gerth, M. (2018). A critical re-evaluation of multilocus sequence typing (MLST) efforts in Wolbachia. FEMS Microbiol. Ecol. 94, 163.

Bordenstein, S.R., and Bordenstein, S.R. (2016). Eukaryotic association module in phage WO genomes from Wolbachia. Nat. Commun. 7, 13155.

Bordenstein, S.R., Marshall, M.L., Fry, A.J., Kim, U., and Wernegreen, J.J. (2006). The tripartite associations between bacteriophage, Wolbachia, and arthropods. PLoS Pathog. 2, e43.

Bordenstein, S.R., Paraskevopoulos, C., DunningHotopp, J.C., et al. (2009). Parasitism and mutualism in Wolbachia: what the phylogenomic trees can and cannot say. Mol. Biol. Evol. 26, 231–241.

Bordenstein, S.R., and Theis, K.R. (2015). Host biology in light of the microbiome: ten principles of Holobionts and Hologenomes. PLoS Biol. 13, e1002226.

Bordenstein, S.R., and Wernegreen, J.J. (2004). Bacteriophage flux in endosymbionts (Wolbachia): infection frequency, lateral transfer, and recombination rates. Mol. Biol. Evol. 21, 1981–1991.

Bouchon, D., Cordaux, R., and Gre\` ve, P. (2008). Feminizing Wolbachia and the evolution of sex determination in isopods. In Insect Symbiosis (Taylor and Francis Group), pp. 273–294.

Bourtzis, K., Dobson, S.L., Xi, Z., Rasgon, J.L., Calvitti, M., Moreira, L.A., Bossin, H.C., Moretti, R., Baton, L.A., Hughes, G.L., et al. (2014). Harnessing mosquito-Wolbachia symbiosis for vector and disease control. Acta Trop. 132 (Supplement ), S150–S163.

Brelsfoard, C., Tsiamis, G., Falchetto, M., Gomulski, L.M., Telleria, E., Alam, U., Doudoumis, V., Scolari, F., Benoit, J.B., Swain, M., et al. (2014). Presence of extensive Wolbachia symbiont insertions discovered in the genome of its host Glossina morsitans morsitans. PLoS Negl. Trop. Dis. 8, e2728.

Brownlie, J.C., Cass, B.N., Riegler, M., Witsenburg, J.J., Iturbe-Ormaetxe, I., McGraw, E.A., and O’Neill, S.L. (2009). Evidence for metabolic provisioning by a common invertebrate endosymbiont, Wolbachia pipientis, during periods of nutritional stress. PLoS Pathog. 5, e1000368.

Brucker, R.M., and Bordenstein, S.R. (2012). Speciation by symbiosis. Trends Ecol. Evol. 27, 443–451.

Caputo, B., Moretti, R., Manica, M., Serini, P., Lampazzi, E., Bonanni, M., Fabbri, G., Pichler, V., della Torre, A., and Calvitti, M. (2020). A bacterium against the tiger: preliminary evidence of fertility reduction after release of Aedes albopictus males with manipulated Wolbachia infection in an Italian urban area. Pest Manag. Sci. 76, 1324–1332.

Cattel, J., Kaur, R., Gibert, P., Martinez, J., Fraimout, A., Jiggins, F., Andrieux, T., Siozios, S., Anfora, G., Miller, W., et al. (2016). Wolbachia in European populations of the invasive pest Drosophila suzukii: regional variation in infection frequencies. PLoS One 11, e0147766.

Chafee, M.E., Zecher, C.N., Gourley, M.L., Schmidt, V.T., Chen, J.H., Bordenstein, S.R., Clark, M.E., and Bordenstein, S.R. (2011). Decoupling of host-symbiont-phage coadaptations following transfer between insect species. Genetics 187, 203–215.

Chrostek, E., Marialva, M., Esteves, S., Weinert, L., Martinez, J., Jiggins, F., Teixeira, L., et al. (2013). Wolbachia Variants Induce Differential Protection to Viruses in Drosophila melanogaster: A Phenotypic and Phylogenomic Analysis. Plos Genetics 9, e1003896.

Clark, M.E., Veneti, Z., Bourtzis, K., and Karr, T.L. (2002). The distribution and proliferation of the intracellular bacteria Wolbachia during spermatogenesis in Drosophila. Mech. Dev. 111, 3–15.

Cooper, B.S., Vanderpool, D., Conner, W.R., Matute, D.R., and Turelli, M. (2019). Wolbachia acquisition by Drosophila yakuba-clade hosts and transfer of incompatibility loci between distantly related Wolbachia. Genetics 212, 1399–1419.

Cordaux, R., and Gilbert, C. (2017). Evolutionary significance of Wolbachia-toanimal horizontal gene transfer: female sex determination and the f element in the isopod Armadillidium vulgare. Genes 8, 186.

Cordaux, R., Pichon, S., Ling, A., Pe´ rez, P., Delaunay, C., Vavre, F., Bouchon, D., and Gre\` ve, P. (2008). Intense transpositional activity of insertion sequences in an ancient obligate endosymbiont. Mol. Biol. Evol. 25, 1889–1896.

Coulibaly, Y.I., Dembele, B., Diallo, A.A., Lipner, E.M., Doumbia, S.S., Coulibaly, S.Y., Konate, S., Diallo, D.A., Yalcouye, D., Kubofcik, J., et al. (2009). A randomized trial of doxycycline for Mansonella perstans infection. N. Engl. J. Med. 361, 1448–1458.

Darby, A.C., Armstrong, S.D., Bah, G.S., Kaur, G., Hughes, M.A., Kay, S.M., Koldkjær, P., Rainbow, L., Radford, A.D., Blaxter, M.L., et al. (2012). Analysis of gene expression from the Wolbachia genome of a filarial nematode supports both metabolic and defensive roles within the symbiosis. Genome Res. 22, 2467–2477.

Dedeine, F., Vavre, F., Fleury, F., Loppin, B., Hochberg, M.E., and Bouletreau, M. (2001). Removing symbiotic Wolbachia bacteria specifically inhibits oogenesis in a parasitic wasp. Proc. Natl. Acad. Sci. USA 98, 6247–6252.

Heath, B.D., Butcher, R.D.J., Whitfield, W.G.F., and Hubbard, S.F. (1999). Horizontal transfer of Wolbachia between phylogenetically distant insect species by a naturally occurring mechanism. Curr. Biol. 9, 313–316.

Duarte, E.H., Carvalho, A., Lo´ pez-Madrigal, S., and Teixeira, L. (2020). Regulation of Wolbachia proliferation by the amplification and deletion of an addictive genomic island. bioRxiv. https://www.biorxiv.org/content/10.1101/2020. 09.08.288217v1#: :text=We%20characterized%20in%20detail%20two,the% 20control%20of%20Wolbachia%20proliferation.

Hedges, L.M., Brownlie, J.C., O’Neill, S.L., and Johnson, K.N. (2008). Wolbachia and virus protection in insects. Science 322, 702.

Hertig, M., and Wolbach, S.B. (1924). Studies on Rickettsia-like micro-organisms in insects. J. Med. Res. 44, 329–374.7.

Dunning Hotopp, J.C., Clark, M.E., Oliveira, D.C.S.G., Foster, J.M., Fischer, P., Mun˜ oz Torres, M.C., Giebel, J.D., Kumar, N., Ishmael, N., Wang, S., et al. (2007). Widespread lateral gene transfer from intracellular bacteria to multicellular eukaryotes. Science 317, 1753–1756.

Hong, W.D., Benayoud, F., Nixon, G.L., Ford, L., Johnston, K.L., Clare, R.H., Cassidy, A., Cook, D.A.N., Siu, A., Shiotani, M., et al. (2019). AWZ1066S, a highly specific anti-Wolbachia drug candidate for a short-course treatment of filariasis. Proc. Natl. Acad. Sci. USA 116, 1414–1419.

Durdevic, Z., Hanna, K., Gold, B., Pollex, T., Cherry, S., Lyko, F., and Schaefer, M. (2013). Efficient RNA virus control in Drosophila requires the RNA methyltransferase Dnmt2. EMBO Rep. 14, 269–275.

Hotopp, J.C.D., Slatko, B.E., and Foster, J.M. (2017). Targeted enrichment and sequencing of recent endosymbiont-host lateral gene transfers. Sci. Rep. 7, 857.

Duron, O., Lagnel, J., Raymond, M., Bourtzis, K., Fort, P., and Weill, M. (2005). Transposable element polymorphism of Wolbachia in the mosquito Culex pipiens: evidence of genetic diversity, superinfection and recombination. Mol. Ecol. 14, 1561–1573.

El Karkouri, K., Pontarotti, P., Raoult, D., and Fournier, P.E. (2016). Origin and evolution of rickettsial plasmids. PLoS One 11, e0147492.

Hurst, G.D.D., and Jiggins, F.M. (2000). Male-killing bacteria in insects: mechanisms, incidence, and implications. Emerg. Infect. Dis. 6, 329–336.

Hurst, G.D.D., Jiggins, F.M., Hinrich Graf von der Schulenburg, J., Bertrand, D., West, S.A., Goriacheva, I.I., Zakharov, I.A., Werren, J.H., Stouthamer, R., and Majerus, M.E.N. (1999). Male-killing Wolbachia in two species of insect. Proc. R. Soc. Lond. B 266, 735–740.

Elias-Costa, A.J., Confalonieri, V.A., Lanteri, A.A., and Rodriguero, M.S. (2019). Game of clones: is Wolbachia inducing speciation in a weevil with a mixed reproductive mode? Mol. Phylogenet. Evol. 133, 42–53.

Fenn, K., and Blaxter, M. (2004). Are filarial nematode Wolbachia obligate mutualist symbionts? Trends Ecol. Evol. 19, 163–166.

Ferree, P.M., Frydman, H.M., Li, J.M., Cao, J., Wieschaus, E., and Sullivan, W. (2005). Wolbachia utilizes host microtubules and Dynein for anterior localization in the Drosophila oocyte. PLoS Pathog. 1, e14.

Indriani, C., Tantowijoyo, W., Rance\` s, E., Andari, B., Prabowo, E., Yusdi, D., Ansari, M.R., Wardana, D.S., Supriyati, E., Nurhayati, I., et al. (2020). Reduced dengue incidence following deployments of Wolbachia-infected Aedes aegypti in Yogyakarta, Indonesia: a quasi-experimental trial using controlled interrupted time series analysis. Gates Open Res. 4, 50.

Ishmael, N., Hotopp, J.C.D., Ioannidis, P., Biber, S., Sakamoto, J., Siozios, S., Nene, V., Werren, J., Bourtzis, K., Bordenstein, S.R., and Tettelin, H. (2009). Extensive genomic diversity of closely related Wolbachia strains. Microbiology 155, 2211–2222.

Flores, H.A., and O’Neill, S.L. (2018). Controlling vector-borne diseases by releasing modified mosquitoes. Nat. Rev. Microbiol. 16, 508–518.

Foray, V., Pe´ rez-Jime´ nez, M.M., Fattouh, N., and Landmann, F. (2018). Wolbachia control stem cell behavior and stimulate germline proliferation in filarial nematodes. Dev. Cell 45, 198–211.e3.

Foster, J., Ganatra, M., Kamal, I., Ware, J., Makarova, K., Ivanova, N., Bhattacharyya, A., Kapatral, V., Kumar, S., Posfai, J., et al. (2005). The Wolbachia genome of Brugia malayi: endosymbiont evolution within a human pathogenic nematode. PLoS Biol. 3, e121.

Johnston, K.L., Ford, L., Umareddy, I., Townson, S., Specht, S., Pfarr, K., Hoerauf, A., Altmeyer, R., and Taylor, M.J. (2014). Repurposing of approved drugs from the human pharmacopoeia to target Wolbachia endosymbionts of onchocerciasis and lymphatic filariasis. Int. J. Parasitol. Drugs Drug Resist. 4, 278–286.

Joubert, D.A., Walker, T., Carrington, L.B., De Bruyne, J.T., Kien, D.H., Hoang, Nle T., Chau, N.V., Iturbe-Ormaetxe, I., Simmons, C.P., and O’Neill, S.L. (2016). Establishment of a Wolbachia superinfection in aedes aegypti mosquitoes as a potential approach for future resistance management. PLoS Pathog. 12, e1005434.

Fukui, T., Kawamoto, M., Shoji, K., Kiuchi, T., Sugano, S., Shimada, T., Suzuki, Y., and Katsuma, S. (2015). The endosymbiotic bacterium Wolbachia selectively kills male hosts by targeting the masculinizing gene. PLoS Pathog. 11, e1005048.

Kambris, Z., Blagborough, A.M., Pinto, S.B., Blagrove, M.S.C., Godfray, H.C.J., Sinden, R.E., and Sinkins, S.P. (2010). Wolbachia stimulates immune gene expression and inhibits plasmodium development in Anopheles gambiae. PLoS Pathog. 6, e1001143.

Funkhouser-Jones, L.J., Sehnert, S.R., Martı´nez-Rodrı´guez, P., Toribio-Ferna´ ndez, R., Pita, M., Bella, J.L., and Bordenstein, S.R. (2015). Wolbachia coinfection in a hybrid zone: Discovery of horizontal gene transfers from two Wolbachia supergroups into an animal genome. PeerJ 3, e1479.

Kampfraath, A.A., Klasson, L., Anvar, S.Y., Vossen, R.H.A.M., Roelofs, D., Kraaijeveld, K., and Ellers, J. (2019). Genome expansion of an obligate parthenogenesis-associated Wolbachia poses an exception to the symbiont reduction model. BMC Genomics 20, 106.

Funkhouser-Jones, L.J., van Opstal, E.J., Sharma, A., and Bordenstein, S.R.   
(2018). The maternal effect gene Wds controls Wolbachia titer in Nasonia.   
Curr. Biol. 28, 1692–1702.e6.

Kaur, R., Martinez, J., Rota-Stabelli, O., Jiggins, F.M., and Miller, W.J. (2020). Age, tissue, genotype and virus infection regulate Wolbachia levels in Drosophila. Mol. Ecol. 29, 2063–2079.

Gerth, M., and Bleidorn, C. (2016). Comparative genomics provides a timeframe for Wolbachia evolution and exposes a recent biotin synthesis operon transfer. Nat. Microbiol. 2, 16241.

Kaur, R., Siozios, S., Miller, W.J., and Rota-Stabelli, O. (2017). Insertion sequence polymorphism and genomic rearrangements uncover hidden Wolbachia diversity in Drosophila suzukii and D. subpulchrella. Sci. Rep. 7, 14815.

Gerth, M., Gansauge, M.T., Weigert, A., and Bleidorn, C. (2014). Phylogenomic analyses uncover origin and spread of the Wolbachia pandemic. Nat. Commun. 5, 5117.

Kent, B.N., and Bordenstein, S.R. (2010). Phage WO of Wolbachia: lambda of the endosymbiont world. Trends Microbiol. 18, 173–181.

Gong, J.T., Li, Y., Li, T.P., Liang, Y., Hu, L., Zhang, D., Zhou, C.Y., Yang, C., Zhang, X., Zha, S.-S., et al. (2020). Stable Introduction of plant-virus-inhibiting Wolbachia into planthoppers for rice protection. Curr. Biol. 30, 4837–4845.e5.

Gottlieb, Y., and Zchori-Fein, E. (2001). Irreversible thelytokous reproduction in Muscidifurax uniraptor. Entomol. Exp. Appl. 100, 271–278.

Hague, M.T.J., Mavengere, H., Matute, D.R., and Cooper, B.S. (2020). Environmental and genetic contributions to imperfect wMel-like Wolbachia transmission and frequency variation. Genetics 215, 1117–1132.

Kittayapong, P., Baisley, K.J., Baimai, V., and O’Neill, S.L. (2000). Distribution and diversity of Wolbachia infections in Southeast Asian mosquitoes (Diptera: Culicidae). J. Med. Entomol. 37, 340–345.

Klasson, L., Walker, T., Sebaihia, M., Sanders, M.J., Quail, M.A., Lord, A., Sanders, S., Earl, J., O’Neill, S.L., Thomson, N., et al. (2008). Genome evolution of Wolbachia strain wPip from the Culex pipiens group. Mol. Biol. Evol. 25, 1877–1887.

Klasson, L., Westberg, J., Sapountzis, P., Naslund, K., Lutnaes, Y., Darby, € A.C., Veneti, Z., Chen, L., Braig, H.R., Garrett, R., et al. (2009). The mosaic

# Cell Host & Microbe Review

genome structure of the Wolbachia wRi strain infecting Drosophila simulans.   
Proc. Natl. Acad. Sci. USA 106, 5725–5730.

Krafsur, A.M., Ghosh, A., and Brelsfoard, C.L. (2020). Phenotypic response of Wolbachia pipientis in a cell-free medium. Microorganisms 8, 1060.

Landmann, F., Bain, O., Martin, C., Uni, S., Taylor, M.J., and Sullivan, W. (2012). Both asymmetric mitotic segregation and cell-to-cell invasion are required for stable germline transmission of Wolbachia in filarial nematodes. Biol. Open 1, 536–547.

Landmann, F., Foster, J.M., Michalski, M.L., Slatko, B.E., and Sullivan, W. (2014). Co-evolution between an endosymbiont and its nematode host: Wolbachia asymmetric posterior localization and AP polarity establishment. PLoS Negl. Trop. Dis. 8, e3096.

Landmann, F., Orsi, G.A., Loppin, B., and Sullivan, W. (2009). Wolbachia-mediated cytoplasmic incompatibility is associated with impaired histone deposition in the male pronucleus. PLoS Pathog. 5, e1000343.

Laven, H. (1967). Eradication of Culex pipiens fatigans through cytoplasmic incompatibility. Nature 216, 383–384.

Le Clec’h, W., Chevalier, F.D., Genty, L., Bertaux, J., Bouchon, D., and Sicard, M. (2013). Cannibalism and predation as paths for horizontal passage of Wolbachia between terrestrial isopods. PLoS One 8, e60232.

Leclercq, S., Giraud, I., and Cordaux, R. (2011). Remarkable abundance and evolution of mobile group II introns in Wolbachia bacterial endosymbionts. Mol. Biol. Evol. 28, 685–697.

Leclercq, S., The´ ze´ , J., Chebbi, M.A., Giraud, I., Moumen, B., Ernenwein, L., Gre\` ve, P., Gilbert, C., and Cordaux, R. (2016). Birth of a W sex chromosome by horizontal transfer of Wolbachia bacterial symbiont genome. Proc. Natl. Acad. Sci. USA 113, 15036–15041.

Lefoulon, E., Bain, O., Makepeace, B.L., D’Haese, C., Uni, S., Martin, C., and Gavotte, L. (2016). Breakdown of coevolution between symbiotic bacteria Wolbachia and their filarial hosts. PeerJ 4, e1840.

Lefoulon, E., Clark, T., Borveto, F., Perriat-Sanguinet, M., Moulia, C., Slatko, B.E., and Gavotte, L. (2020). Pseudoscorpion Wolbachia symbionts: diversity and evidence for a new supergroup S. BMC Microbiol. 20, 188.

Lemon, A., Bordenstein, S.R., and Bordenstein, S.R. (2020). Discover the microbes within! the Wolbachia project: citizen science and student-based discoveries for 15 years and counting. Genetics 216, 263–268.

LePage, D.P., Metcalf, J.A., Bordenstein, S.R., On, J., Perlmutter, J.I., Shropshire, J.D., Layton, E.M., Funkhouser-Jones, L.J., Beckmann, J.F., and Bordenstein, S.R. (2017). Prophage WO genes recapitulate and enhance Wolbachia-induced cytoplasmic incompatibility. Nature 543, 243–247.

Li, S.J., Ahmed, M.Z., Lv, N., Shi, P.Q., Wang, X.M., Huang, J.L., and Qiu, B.L. (2017). Plantmediated horizontal transmission of Wolbachia between whiteflies. ISME J. 11, 1019–1028.

Lindsey, A.R.I., Bhattacharya, T., Hardy, R.W., and Newton, I.L.G. (2020). Wolbachia and virus alter the host transcriptome at the interface of nucleotide metabolism pathways. bioRxiv. https://www.biorxiv.org/content/10.1101/ 2020.06.18.160317v1#: :text=Wolbachia%20is%20a%20maternally% 20transmitted,promising%20tool%20for%20vector%20control.

Lindsey, A.R.I., Rice, D.W., Bordenstein, S.R., Brooks, A.W., Bordenstein, S.R., and Newton, I.L.G. (2018). Evolutionary genetics of cytoplasmic incompatibility genes cifA and cifB in prophage WO of Wolbachia. Genome Biol. Evol. 10, 434–451.

Lindsey, A.R.I., Werren, J.H., Richards, S., and Stouthamer, R. (2016).   
Comparative genomics of a parthenogenesis-inducing Wolbachia symbiont.   
G3 (Bethesda) 6, 2113–2123.

Ling, A., and Cordaux, R. (2010). Insertion sequence inversions mediated by ectopic recombination between terminal inverted repeats. PLoS One 5, e15654.

Lu, P., Sun, Q., Fu, P., Li, K., Liang, X., and Xi, Z. (2020). Wolbachia inhibits binding of Dengue and Zika viruses to mosquito cells. Front. Microbiol. 11, 1750.

Ma, W.J., and Schwander, T. (2017). Patterns and mechanisms in instances of endosymbiont-induced parthenogenesis. J. Evol. Biol. 30, 868–888.

Mains, J.W., Kelly, P.H., Dobson, K.L., Petrie, W.D., and Dobson, S.L. (2019). Localized Control of Aedes aegypti (Diptera: Culicidae) in Miami, FL, via inundative releases of Wolbachia-Infected male mosquitoes. J. Med. Entomol. 56, 1296–1303.

Martinez, J., Klasson, L., Welch, J.J., and Jiggins, F.M. (2021). Life and death of selfish genes: comparative genomics reveals the dynamic evolution of cytoplasmic incompatibility. Mol. Biol. Evol. 38, 2–15.

Masui, S., Kuroiwa, H., Sasaki, T., Inui, M., Kuroiwa, T., and Ishikawa, H. (2001). Bacteriophage WO and virus-like particles in Wolbachia, an endosymbiont of arthropods. Biochem. Biophys. Res. Commun. 283, 1099–1104.

Mavingui, P., Valiente Moro, C.V., Tran-Van, V., Wisniewski-Dye´ , F., Raquin, V., Minard, G., Tran, F.H., Voronin, D., Rouy, Z., Bustos, P., et al. (2012). Whole-genome sequence of Wolbachia strain wALbB, an endosymbiont of tiger mosquito vector Aedes albopictus. J. Bacteriol. 194, 1840.

McFall-Ngai, M. (2008). Are biologists in ‘‘future shock’’? Symbiosis integrates biology across domains. Nat. Rev. Microbiol. 6, 789–792.

McMeniman, C.J., Lane, R.V., Cass, B.N., Fong, A.W., Sidhu, M., Wang, Y.F., and O’Neill, S.L. (2009). Stable introduction of a life-shortening Wolbachia infection into the mosquito Aedes aegypti. Science 323, 141–144.

Miller, W.J., Ehrman, L., and Schneider, D. (2010). Infectious Speciation Revisited: Impact of Symbiont-Depletion on Female Fitness and Mating Behavior of Drosophila paulistorum. Plos Pathogens 6, e1001214.

Min, K.T., and Benzer, S. (1997). Wolbachia, normally a symbiont of Drosophila, can be virulent, causing degeneration and early death. Proc. Natl. Acad. Sci. USA 94, 10792–10796.

Mitsuhashi, W., Ikeda, H., and Muraji, M. (2011). Fifty-year trend towards suppression of Wolbachia-induced male-killing by its butterfly host, Hypolimnas bolina. J. Insect Sci. 11, 92.

Mouton, L., Dedeine, F., Henri, H., Boule´ treau, M., Profizi, N., and Vavre, F. (2004). Virulence, multiple infections and regulation of symbiotic population in the Wolbachia-Asobara tabida symbiosis. Genetics 168, 181–189.

Nazni, W.A., Hoffmann, A.A., NoorAfizah, A., Cheong, Y.L., Mancini, M.V., Golding, N., Kamarul, G.M.R., Arif, M.A.K., Thohir, H., NurSyamimi, H., et al. (2019). Establishment of Wolbachia strain wAlbB in Malaysian populations of Aedes aegypti for dengue control. Curr. Biol. 29, 4241–4248.e5.

Newton, I.L.G., Clark, M.E., Kent, B.N., Bordenstein, S.R., Qu, J., Richards, S., Kelkar, Y.D., and Werren, J.H. (2016). Comparative genomics of two closely related Wolbachia with different reproductive effects on hosts. Genome Biol. Evol. 8, 1526–1542.

Newton, I.L.G., Savytskyy, O., and Sheehan, K.B. (2015). Wolbachia utilize host actin for efficient maternal transmission in Drosophila melanogaster. PLoS Pathog. 11, e1004798.

Nikoh, N., Hosokawa, T., Moriyama, M., Oshima, K., Hattori, M., and Fukatsu, T. (2014). Evolutionary origin of insect-Wolbachia nutritional mutualism. Proc. Natl. Acad. Sci. USA 111, 10257–10262.

Ogunlade, S.T., Meehan, M.T., Adekunle, A.I., Rojas, D.P., Adegboye, O.A., and McBryde, E.S. (2021). A Review: Aedes-borne arboviral infections, controls and Wolbachia-based strategies. Vaccines 9, 32.

O’Neill, S.L., Giordano, R., Colbert, A.M., Karr, T.L., and Robertson, H.M. (1992). 16S rRNA phylogenetic analysis of the bacterial endosymbionts associated with cytoplasmic incompatibility in insects. Proc. Natl. Acad Sci. U S A 89, 2699–702.

Ote, M., Ueyama, M., and Yamamoto, D. (2016). Wolbachia protein TomO targets nanos mRNA and restores germ stem cells in Drosophila sex-lethal mutants. Curr. Biol. 26, 2223–2232.

Parry, R., and Asgari, S. (2018). Aedes Anphevirus: an insect-specific virus distributed worldwide in Aedes aegypti mosquitoes that has complex interplays with Wolbachia and dengue virus infection in cells. J. Virol. 92, e00224–18.

Perlmutter, J.I., Bordenstein, S.R., Unckless, R.L., LePage, D.P., Metcalf, J.A., Hill, T., Martinez, J., Jiggins, F.M., and Bordenstein, S.R. (2019). The phage gene wmk is a candidate for male killing by a bacterial endosymbiont. PLoS Pathog. 15, e1007936.

complex functional repertoire and new essential regions in CifB. PLoS Pathog.   
16, e1008794.

Shropshire, J.D., On, J., Layton, E.M., Zhou, H., and Bordenstein, S.R. (2018). One prophage WO gene rescues cytoplasmic incompatibility in Drosophila melanogaster. Proc. Natl. Acad. Sci. U S A 115., 4987–4991.

Shropshire, J.D., Rosenberg, R., and Bordenstein, S.R. (2021). The impacts of cytoplasmic incompatibility factor (cifA and cifB) genetic variation on phenotypes. Genetics 217, 1–13.

Slatko, B.E., Luck, A.N., Dobson, S.L., and Foster, J.M. (2014). Wolbachia endosymbionts and human disease control. Mol. Biochem. Parasitol. 195, 88–95.

Stouthamer, R., Russell, J.E., Vavre, F., and Nunney, L. (2010). Intragenomic conflict in populations infected by parthenogenesis inducing Wolbachia ends with irreversible loss of sexual reproduction. BMC Evol. Biol. 10, 229.

Stouthamer, R., Van Tilborg, M., De Jong, J.H., Nunney, L., and Luck, R.F. (2001). Selfish element maintains sex in natural populations of a parasitoid wasp. Proc. Biol. Sci. 268, 617–622.

Taylor, M.J., Bandi, C., and Hoerauf, A. (2005). Wolbachia bacterial endosymbionts of filarial nematodes. Adv. Parasitol. 60, 245–284.

Taylor, M.J., Von Geldern, T.W., Ford, L., Hubner, M.P., Marsh, K., John-€ ston, K.L., Sjoberg, H.T., Specht, S., Pionnier, N., Tyrer, H.E., et al. (2019). Preclinical development of an oral anti-Wolbachia macrolide drug for the treatment of lymphatic filariasis and onchocerciasis. Sci. Transl. Med. 11, eaau2086.

Teixeira, L., Ferreira, A., and Ashburner, M. (2008). The bacterial symbiont Wolbachia induces resistance to RNA viral infections in Drosophila melanogaster. PLoS Biol. 6, e2.

Pietri, J.E., DeBruhl, H., and Sullivan, W. (2016). The rich somatic life of Wolbachia. MicrobiologyOpen 5, 923–936.   
Poinsot, D., Bourtzis, K., Markakis, G., Savakis, C., and Merc¸ ot, H. (1998). Wolbachia transfer from Drosophila melanogaster into D. simulans: host effect and cytoplasmic incompatibility relationships. Genetics 150, 227–237.   
Puggioli, A., Calvitti, M., Moretti, R., and Bellini, R. (2016). wPip Wolbachia contribution to Aedes albopictus SIT performance: advantages under intensive rearing. Acta Trop 164, 473–481.   
Qin, A.P., Tucker, A.M., Hines, A., and Wood, D.O. (2004). Transposon mutagenesis of the obligate intracellular pathogen Rickettsia prowazekii. Appl. Environ. Microbiol. 70, 2816–2822.   
Rance\` s, E., Ye, Y.H., Woolfit, M., McGraw, E.A., and O’Neill, S.L. (2012). The relative importance of innate immune priming in Wolbachia-mediated dengue interference. PLoS Pathog. 8, e1002548.   
Rasgon, J.L., Gamston, C.E., and Ren, X. (2006). Survival of Wolbachia pipientis in cell-free medium. Appl. Environ. Microbiol. 72, 6934–6937.   
Raychoudhury, R., Baldo, L., Oliveira, D.C.S.G., and Werren, J.H. (2009). Modes of acquisition of Wolbachia: horizontal transfer, hybrid introgression, and codivergence in the Nasonia species complex. Evolution 63, 165–183. Reveillaud, J., Bordenstein, S.R., Cruaud, C., Shaiber, A., Esen, O¨ .C., Weill, M., Makoundou, P., Lolans, K., Watson, A.R., Rakotoarivony, I., et al. (2019). The Wolbachia mobilome in Culex pipiens includes a putative plasmid. Nat. Commun. 10, 1051.   
Rice, D.W., Sheehan, K.B., and Newton, I.L.G. (2017). Large-scale identification of Wolbachia pipientis effectors. Genome Biol. Evol. 9, 1925–1937. Rigaud, T., and Juchault, P. (1992). Genetic control of the vertical transmission of a cytoplasmic sex factor in Armadillidium vulgare Latr. (Crustacea, Oniscidea). Heredity 68, 47–52.   
Rigaud, T., Soutygrosset, C., Raimond, R., Mocquard, J.P., and Juchault, P. (1991). Feminizing endocytobiosis in the terrestrial crustacean Armadihidium vulgare latr. (Isopoda) - recent acquisitions. Endocytobiosis & Cell Res. 7, 259–273.   
Riparbelli, M.G., Giordano, R., and Callaini, G. (2007). Effects of Wolbachia on sperm maturation and architecture in Drosophila simulans Riverside. Mech. Dev. 124, 699–714.   
Ryan, P.A., Turley, A.P., Wilson, G., Hurst, T.P., Retzki, K., Brown-Kenyon, J., Hodgson, L., Kenny, N., Cook, H., Montgomery, B.L., et al. (2019). Establishment of wMel Wolbachia in Aedes aegypti mosquitoes and reduction of local dengue transmission in Cairns and surrounding locations in northern Queensland, Australia. Gates Open Res. 3, 1547.   
Sanogo, Y.O., Dobson, S.L., Bordenstein, S.R., and Novak, R.J. (2007). Disruption of the Wolbachia surface protein gene wspB by a transposable element in mosquitoes of the Culex pipiens complex (Diptera, Culicidae). Insect Mol. Biol. 16, 143–154.   
Scholz, M., Albanese, D., Tuohy, K., Donati, C., Segata, N., and Rota-Stabelli, O. (2020). Large scale genome reconstructions illuminate Wolbachia evolution. Nat. Commun. 11, 5235.   
Schultz, M.J., Tan, A.L., Gray, C.N., Isern, S., Michael, S.F., Frydman, H.M., and Connor, J.H. (2018). Wolbachia wStri blocks Zika virus growth at two independent stages of viral replication. mBio 9, e00738–18.   
Serbus, L.R., Casper-Lindley, C., Landmann, F., and Sullivan, W. (2008). The genetics and cell biology of Wolbachia-host interactions. Annu. Rev. Genet. 42, 683–707.   
Shropshire, J.D., and Bordenstein, S.R. (2016). Speciation by symbiosis: the microbiome and behavior. mBio 7, e01785.   
Shropshire, J.D., and Bordenstein, S.R. (2019). Two-by-one model of cytoplasmic incompatibility: synthetic recapitulation by transgenic expression of cifA and cifB in Drosophila. PLoS Genet. 15, e1008221.   
Shropshire, J.D., Leigh, B., Bordenstein, S.R., and Initiative, M. (2020a). Symbiont-mediated cytoplasmic incompatibility: What have we learned in 50 years? eLife 9, 1–51.   
Shropshire, J.D., Kalra, M., and Bordenstein, S.R. (2020b). Evolution-guided mutagenesis of the cytoplasmic incompatibility proteins: Identifying CifA’s

Tram, U., and Sullivan, W. (2002). Role of delayed nuclear envelope breakdown and mitosis in Wolbachia-induced cytoplasmic incompatibility. Science 296, 1124–1126.

Turelli, M., Cooper, B.S., Richardson, K.M., Ginsberg, P.S., Peckenpaugh, B., Antelope, C.X., Kim, K.J., May, M.R., Abrieux, A., Wilson, D.A., et al. (2018). Rapid global spread of wRi-like Wolbachia across multiple Drosophila. Curr. Biol. 28, 963–971.e8.

Vaishampayan, P.A., Dhotre, D.P., Gupta, R.P., Lalwani, P., Ghate, H., Patole, M.S., and Shouche, Y.S. (2007). Molecular evidence and phylogenetic affiliations of Wolbachia in cockroaches. Mol. Phylogenet. Evol. 44, 1346–1351.

Walker, T., Johnson, P.H., Moreira, L.A., Iturbe-Ormaetxe, I., Frentiu, F.D., McMeniman, C.J., Leong, Y.S., Dong, Y., Axford, J., Kriesner, P., et al. (2011). The wMel Wolbachia strain blocks dengue and invades caged Aedes aegypti populations. Nature 476, 450–453.

Weinert, L.A., Araujo, E.V.-Jnr, E.V., Ahmed, M.Z., and Welch, J.J. (2015). The incidence of bacterial endosymbionts in terrestrial arthropods. Proc. R. Soc. Lond. B Biol. Sci. 282, 20150249.

Werren, J.H., Zhang, W., and Guo, L.R. (1995). Evolution and phylogeny of Wolbachia: reproductive parasites of arthropods. Proc. Biol. Sci. 261, 55–63.

Wong, Z.S., Hedges, L.M., Brownlie, J.C., and Johnson, K.N. (2011). Wolbachia-mediated antibacterial protection and immune gene regulation in Drosophila. PLoS One 6, e25430.

Wu, M., Sun, L.V., Vamathevan, J., Riegler, M., Deboy, R., Brownlie, J.C., McGraw, E.A., Martin, W., Esser, C., Ahmadinejad, N., et al. (2004). Phylogenomics of the reproductive parasite Wolbachia pipientis wMel: a streamlined genome overrun by mobile genetic elements. PLoS Biol. 2, E69.

Wu, X., Lindsey, A.R.I., Chatterjee, P., Werren, J.H., Stouthamer, R., and Yi, S.V. (2020). Distinct epigenomic and transcriptomic modifications associated with Wolbachia-mediated asexuality. PLoS Pathog. 16, e1008397.

Xi, Z., Dean, J.L., Khoo, C., and Dobson, S.L. (2005). Generation of a novel Wolbachia infection in Aedes albopictus (Asian tiger mosquito) via embryonic microinjection. Insect Biochem Mol. Biol. 35, 903–910.

Yen, P.S., and Failloux, A.B. (2020). A Review: Wolbachia-Based Population Replacement for Mosquito Control Shares Common Points with Genetically

# Cell Host & Microbe Review

Modified Control Approaches. Pathogens 404, https://doi.org/10.3390/ pathogens9050404.

Zhang, G., Hussain, M., O’Neill, S.L., and Asgari, S. (2013). Wolbachia uses a host microRNA to regulate transcripts of a methyltransferase, contributing to dengue virus inhibition in Aedes aegypti. Proc. Natl. Acad Sci. U S A 110, 10276–10281.

Zheng, X., Zhang, D., Li, Y., Yang, C., Wu, Y., Liang, X., Liang, Y., Pan, X., Hu., L., and Sun, Q. (2019). Incompatible and sterile insect techniques combined eliminate mosquitoes. Nature 572, 56–61.

Zhou, W., Rousset, F., and O’Neill, S. (1998). Phylogeny and PCR-based classification of Wolbachia strains using wsp gene sequences. Proc. Biol. Sci. 265, 509–515.